Attribute VB_Name = "Declarations"

Public intKI2510 As Integer                 '2510 GPIB Address
Public intModel As Integer                  'Type of instrument (2510-AT, 2510, Other)
Public Const intOther = 0                   'Value for intModel other instrument (not a 2510-AT (firmware >7)or 2510)
Public Const int2510AT = 1                  'Value for intModel for 2510-AT
Public Const int2510 = 2                    'Value for intModel for 2510
Public sngFWRev As Single                   '2510/2510-AT Firmware revision value
Public intDUTType As Integer                'DUT type
Public Const intDemo = 0                    'Demo DUT is type = 0
Public Const intExpert = 1                  'Expert DUT is type = 1

Public blnSetFile As Boolean                'Stores state of settings file (exist/doesn't exist)
Public intLineFreq As Integer               'Stores chosen A/D control Line Frequency (50 or 60 Hz)
Public strTempTrans As String               'Stores transducer type (THERmistor|RTD)
Public blnAutotuneMode As Boolean           'In autotune mode?
Public strRangeorType As String             'Store RTD type or thermistor range
Public sngTolerance As Single               'Temperature setpoint tolerance (%)
Public intWindow As Integer                 'Temperature setpoint window (# of points)

Public Const maxNumPoints = 1200           'Max number of temp readings
Public sngChartArray(1 To 2, 1 To maxNumPoints)     'Time & temperature readings for charting

Public sngOperKp As Single              'Kp to be used for PID (operational), based on chosen option button
Public sngOperKi As Single              'Temporary storage for chosen Ki
Public sngOperKd As Single              'Temporary storage for chosen Kd

Public strMSETKp As String                  'Minimum Temp Settle Time Kp
Public strMSETKi As String                  'Minimum Temp Settle Time Ki
Public strMSETKd As String                  'Minimum Temp Settle Time Kd

Public strMOVKp As String                   'Minimum Temp Overshoot Kp
Public strMOVKi As String                   'Minimum Temp Overshoot Ki
Public strMOVKd As String                   'Minimum Temp Overshoot Kd

Public strpresKp As String              'present/initial Kp (proportional) coeff stored in 2510
Public strpresKi As String              'present Ki (integral)
Public strpresKd As String              'present Kd (derivative)

Public Const minPID = 0                        'Minimum allowable value for P, I, or D coeff
Public Const max2510P = 999.999                'Max allowable 2510 P coeff
Public Const max2510ID = 100                    'Max allowable 2510 I or D coeff
Public Const max2510ATPID = 100000               'Max allowable 2510-AT P, I, or D coeff and 2510 with firmware >6

Public arraydata(1 To 2, 1 To 3000) As Single    'data array for charting temperature vs time

